/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.ui.containers.views.pagination.updaters;

import net.impactdev.impactor.api.items.ImpactorItemStack;
import net.impactdev.impactor.api.ui.containers.views.pagination.updaters.PageUpdaterType;
import net.impactdev.impactor.api.utility.builders.Builder;

public final class PageUpdater {
    private final PageUpdaterType type;
    private final int slot;
    private final UpdaterProvider provider;

    private PageUpdater(PageUpdaterType type, int slot, UpdaterProvider provider) {
        this.type = type;
        this.slot = slot;
        this.provider = provider;
    }

    public PageUpdaterType type() {
        return this.type;
    }

    public int slot() {
        return this.slot;
    }

    public UpdaterProvider provider() {
        return this.provider;
    }

    public static PageUpdaterBuilder builder() {
        return new PageUpdaterBuilder();
    }

    @FunctionalInterface
    public static interface UpdaterProvider {
        public ImpactorItemStack provide(int var1);
    }

    public static class PageUpdaterBuilder
    implements Builder<PageUpdater> {
        private PageUpdaterType type;
        private int slot;
        private UpdaterProvider provider;

        public PageUpdaterBuilder type(PageUpdaterType type) {
            this.type = type;
            return this;
        }

        public PageUpdaterBuilder slot(int slot) {
            this.slot = slot;
            return this;
        }

        public PageUpdaterBuilder provider(UpdaterProvider provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public PageUpdater build() {
            return new PageUpdater(this.type, this.slot, this.provider);
        }
    }
}

